      Program TRT2
      Character*12 FILEI,FILEO
      Character*50 DESC
      Integer IDUM,N,IDUM1,ITRAN,ip,iq,kountmax,kountp,ichek
      Parameter (N1=1500,KMAX1=50)
      Real Y(N1),time(N1),SDTR(KMAX1),VARTR(KMAX1)
      Real TR(KMAX1),STR(KMAX1)
      Real TSTR(KMAX1),num,denom
      Real arp(12),map(12),res(n1),Z(n1),innov(n1)
      Real mcarp(12),mcmap(12)
      Integer id,im,iy
      Real port,tport

C

C
C Program calculates Ramsey and Rothman (1996) standardized TR Test
C statistics for the ARMA(p,q) residuals for the given time series. The
C standard deviation of the TR test statistics is calculated as in
C Equation (10) of Ramsey and Rothman (1996). A portmanteau version
C of the TR Test, as described in Rothman (1994), is also calculated.
C A Monte Carlo simulation is run to estimate the p-values of the
C maximum (in absolute value) of standardized TR test statistics and
C of the portmanteau statistic.
C
C The program reads input parameters from a file called 'trt2.cnl'. The
C contents of this file should be set as follows:
C
C Line  1: number of iterations for Monte Carlo simulations (integer)
C Line  2: Order p of ARMA(p,q) model used to get residuals
C          (Note: set to 0 if raw series appears to be white noise)
C Line  3: Order q of ARMA(p,q) model used to get residuals
C          (Note: set to 0 if raw series appears to be white noise)
C Line  4: Integer-valued variable called 'ITRAN' by the program and
C          set as follows:
C
C            ITRAN = 0, use raw data
C            ITRAN = 1, use logarithm of data
C            ITRAN = 2, use log-1st differences of data
C            ITRAN = 3, use raw (no log) 1st differences of data
C            ITRAN = 4, use log-linear detrended data
C            ITRAN = 5, use raw linear detrended data
C
C Line  5: number of observations in series (integer)
C          Note: Program set to handle a maximum of 1500 observations.
C                To analyze a longer series, increase value of the
C                parameter 'N1' in the fifth line of the program.
C Line  6: Maximum lag at which to calculate TR Test statistics
C          (integer)
C          Note: Program set to handle a maximum of the first 50 lags.
C                To also test at lags above 50, increase the value of
C                the parameter 'KMAX1' in the fifthe line of the program.
C Line  7: Integer seed for IMSL random number generator in the range
C          (0,2147483646)
C Line  8: Name of file containing data
C Line  9: Description of data
C Line 10: Name of output file to which results will be written
C
C
C NOTE: The program makes call to some IMSL routines. If you wish to
C make any change and then compile and link, you will need access to
C IMSL. If you run into problems, feel free to contact:
C
C       Philip Rothman
C       Department of Economics
C       Brewster Building
C       East Carolina University
C       Greenville, NC 27858  USA
C       Phone:  919-328-6151
C       Fax:    919-328-6743
C       Email:  ecrothma@ecuvax.cis.ecu.edu
C
C
C REFERENCES:
C
C Ramsey, J.B. and P. Rothman (1996), "Time Irreversibility and
C    Business Cycle Asymmetry," JOURNAL OF MONEY, CREDIT, AND BANKING,
C    28, 1-21.
C
C Rothman, P. (1994), "Time Irreversible Stock Returns," in BUSINESS
C    CYCLES: THEORY AND METHODS, Semmler, W. (ed.), Kluwer Academic
C    Publishers, 389-403.
C
C


C
C     Get Date
C
      Call GETDAT(iy,im,id)
      iy = iy-1900



C
C     Read input file
C
      Open(unit=7,file='trt2.cnl')
      Read (7,*) ITER
      Read (7,*) ip
      Read (7,*) iq
      Read (7,*) ITRAN
      Read (7,*) N
      Read (7,*) KMAX
      Read (7,*) IDUM
      Read (7,1000) FILEI
      Read (7,1001) DESC
      Read (7,1000) FILEO

      If (ip .lt. 0) Then
	 Write (6,*) 'Error: p of ARMA(p,q) is negative!!'
	 Stop
      End If
      If (iq .lt. 0) Then
	 Write (6,*) 'Error: q of ARMA(p,q) is negative!!'
	 Stop
      End If

      IDUM1 = IDUM
      ichek = ip + iq
      nobs1 = n

C
C     Read in Data from file "FILEI"
C
      Open(unit=8,file=FILEI)
      Do 11,t=1,N
	 Read (8,*) Y(t)
11    Continue

C
C     Carry out data transformations if requested
C
      If ((ITRAN .eq. 1) .or. (ITRAN .eq. 2) .or. (ITRAN .eq. 4)) Then
	 Do 110,t=1,N
	    Y(t) = log(Y(t))
110      Continue
      End If

      If ((ITRAN .eq. 2) .or. (ITRAN .eq. 3)) Then
	 N = N-1
	 Do 111,t=1,N
	    Y(t) = Y(t+1) - Y(t)
111      Continue
      End If

      If ((ITRAN .eq. 4) .or. (ITRAN .eq. 5)) Then
	 Do 112,t=1,n
	    time(t) = t
112      Continue
	 Call DETREND(Y,n,time)
      End If




C
C  Store ARMA(p,q) residuals in array 'Y' if required
C

       If (ichek .gt. 0) Then
	  Call ESTARMA(Y,res,n,ip,iq,arp,map)
	  n=n-ip
	  do 12,t=1,n
	     Y(t) = res(t)
12        continue
       End If


C
C     Calculate TR(k) values for array 'Y' with call to CALCTR.
C     Upon return the array 'SDTR' contains the standard deviations
C     of the TR(k) values calculated under the assumption of iid.
C

      CALL CALCTR(KMAX,n,Y,TR,SDTR,VARTR)

C
C     Standardize TR(k) statistics
C
      Do 3,k=1,KMAX
	 STR(k) = TR(k) / SDTR(k)
3     Continue

C
C     Portmanteau statistic: sum of STR(k)^2
C
      port = 0.0
      Do 88,k=1,KMAX
	 port = port + (STR(k)**2)
88    Continue


C
C     Get max STR(k) value, k=1,...,KMAX.
C
      TRMAX = 0.0
      Do 4,k=1,KMAX
	 If ( (abs(STR(k))) .gt. TRMAX) Then
	    TRMAX = abs(STR(k))
	 End If
4     Continue



C
C     Do MC Run to Get P-Value of 'TRMAX' and 'port'
C

C
C     Initialize 'kountmax' and 'kountp' to 0
C
      kountmax = 0
      kountp = 0

      Do 6,i=1,ITER

C
C        Generate series & store it in array 'Z'
C
	 Call GENARMA(Z,nobs1,ip,iq,arp,map,IDUM,innov)
C
C        If required, store ARMA(p,q) residuals in array 'Z'
C
	 If (ichek .gt. 0) Then
	    Call ESTARMA(Z,res,nobs1,ip,iq,mcarp,mcmap)
	    n=nobs1-ip
	    do 122,t=1,n
	       Z(t) = res(t)
122         continue
	 End If
C
C        Calculate TR test statistics for array 'Z' with call
C        to 'CALCTR'
C

	 CALL CALCTR(KMAX,n,Z,TR,SDTR,VARTR)

C
C        Standardize TR statistics and store in array 'TSTR'
C

	 Do 7,k=1,KMAX
	    TSTR(k) = TR(k) / SDTR(k)
7        Continue

C
C        Portmanteau statistic for this run
C
	 tport = 0.0
	 Do 77,k=1,KMAX
	    tport = tport + (TSTR(k)**2)
77       Continue

C
C        Store maximum standardized TR statistic for this run
C        as 'TRMAXCHK'
C
	 TRMAXCHK = 0.0
	 Do 8,k=1,KMAX
	    If ( (abs(TSTR(k))) .gt. TRMAXCHK) Then
	       TRMAXCHK = abs(TSTR(k))
	    End If
8        Continue

C
C        Check to see if 'TRMAX' > 'TRMAXCHK'
C
	 
	 If (TRMAX .gt. TRMAXCHK) Then
	    kountmax = kountmax + 1
	 End If
C
C        Check to see if 'port' > 'tport'
C
	 If (port .gt. tport) Then
	    kountp = kountp + 1
	 End If


	 If (kount .lt. 100) Then
	     kount = kount + 1
	 End If
	 If (kount .eq. 100) Then
	     Write (6,2222) i
	     kount = 0
	 End If


6     Continue

C
C     Get p-value for 'TRMAX'
C

      num = real(kountmax)
      denom = real(iter)
      pvalue = 1.0 - (num/denom)

C
C     Get p-value for 'port'
C

      num = real(kountp)
      pvalue2 = 1.0 - (num/denom)


C
C     Write out Standardized TR(k) Values
C

C
C     Open output file and write out program information and results
C
      OPEN(UNIT=9,FILE=FILEO)


C
C    Write name of test
C
      If (ichek .gt. 0) Then
	  Write (9,2004)
      End If
      If (ichek .eq. 0) Then
	  Write (9,3004)
      End If
      Write (9,*) ' '
      Write (9,2005)
      Write (9,*) ' '

C
C     Write out date program run
C
      If ( (im .lt. 10) .and. (id .lt. 10) ) Then
	 Write (9,2001) im,id,iy
      End If
      If ( (im .lt. 10) .and. (id .gt. 10) ) Then
	 Write (9,2002) im,id,iy
      End If
      If ( (im .gt. 10) .and. (id .lt. 10) ) Then
	 Write (9,2003) im,id,iy
      End If
      Write (9,*) ' '


      Write (9,298) FILEI
      Write (9,300)
      Write (9,297) DESC
      Write (9,300)
      If (ITRAN .eq. 0) Then
	 Write (9,400) 
      End If
      If (ITRAN .eq. 1) Then
	 Write (9,401) 
      End If
      If (ITRAN .eq. 2) Then
	 Write (9,402) 
      End If
      If (ITRAN .eq. 3) Then
	 Write (9,403) 
      End If
      If (ITRAN .eq. 4) Then
	 Write (9,404) 
      End If
      If (ITRAN .eq. 5) Then
	 Write (9,405) 
      End If
      Write (9,300)

      If (ichek .gt. 0) Then
	 Write (9,2006) ip,iq
      End If

      Write (9,300)
      Write (9,303) nobs1
      Write (9,300)
      Write (9,304) ITER
      Write (9,300)
      Write (9,305) IDUM1
      Write (9,300)
      Write (9,306)
      Write (9,300)
      DO 5 k=1,KMAX
	 Write (9,307) k,STR(k)
	 Write (9,300)
5     Continue
      Write (9,300)
      Write (9,300)
      Write (9,313)
      Write (9,*) ' '
      Write (9,308) TRMAX
      Write (9,309) pvalue
      Write (9,*) ' '
      Write (9,*) ' '
      Write (9,310) KMAX
      Write (9,311) port
      Write (9,312) pvalue2
      Write (9,*) ' '
      Write (9,*) ' '
      Write (9,2009)
      Write (9,2010)

C
C     Format statements
C

297   Format (1x,'-',a50)
298   Format (1x,'-Data used from file: ',a12)
c299   Format (1X,'TRTEST') 
300   Format (1X,' ')
303   Format (1X,'-Number of observations in series: ',I6)
304   Format (1X,'-Number of iterations in MC simulations: ',I6)
305   Format (1X,'-Initial integer seed [in range (0,2147483646)]: ',
     $ I12)
306   Format (1x,'-Standardized TR Statistics')
307   Format(1X,'     k = ',I3,', TR(k)/SDTR(k) = ',F14.3)
308   Format (1x,'  Absolute Value of Maximum Standardized', 
     $' TR Statistic:  ', F14.3)
309   Format (1x,'  P-Value of Maximum Standardized TR Statistic: ',
     $ '        ',F14.3)
310   Format (1x,'  Portmanteau statistic calculated across lags',
     $ ' 1 to:           ',i3)
311   Format (1x,'  Value of portmanteau statistic: ',
     $ '                     ',F15.3)
312   Format (1x,'  P-Value of portmanteau statistic: ',
     $ '                    ',F14.3)
313   Format (1x,'-Joint Test Results')
400   Format (1x,'-Raw data in file used')
401   Format (1x,'-Logarithm of data in file used')
402   Format (1x,'-Log 1st differences in file  used')
403   Format (1x,'-Raw 1st differences in file used')
404   Format (1x,'-Data in file log-linear detrended')
405   Format (1x,'-Data in file linear detrended')
1000  Format (a12)
1001  Format (a50)
2001  Format (1x,'-Date Program Run (month,date,year): 0',
     $ i1,'/0',i1,'/',i2)
2002  Format (1x,'-Date Program Run (month,date,year): 0',
     $ i1,'/',i2,'/',i2)
2003  Format (1x,'-Date Program Run (month,date,year): ',
     $ i2,'/0',i1,'/',i2)
2004  Format (1x,' TR Test Program: Test Run on ARMA Residuals')
2005  Format (1x,'-Written by Philip Rothman, East Carolina', 
     $ ' University') 
2006  Format (1X,'-Order of ARMA(p,q) Model Fitted to Series:',
     $ ' p = ',i2,', q = ',i2)
2009  Format (1x,'-Note: Rejections with this program are',
     $ ' consistent with Type I')
2010  Format (1x,' Time Irreversibility as defined in',
     $ ' Ramsey & Rothman (1996).')

2222   Format (1X,'MC Run, iteration #: ',I5)
3004  Format (1x,' TR Test Program: Test Run on Raw Data which',
     $ ' Appear to be White Noise')

      Stop
      End


      Subroutine DETREND(x,n,time)
      Real x(n),time(n),a,b,sxt,stt,Meanx,Meant
C
C     Get Means
C
      Sumx = 0.0
      Sumt = 0.0
      Do 1,t=1,n
	 Sumx = Sumx + x(t)
	 Sumt = Sumt + time(t)
1     Continue

      Meanx = Sumx/real(n)
      Meant = Sumt/real(n)

C
C     Get Squared time Deviations and Cross Products
C
      stt = 0.0
      sxt = 0.0
      Do 2,t=1,n
	 stt = stt + (time(t) - Meant)**2
	 sxt = sxt + (x(t) - Meanx)*(time(t) - Meant)
2     Continue
C
C     Get OLS estimates for a and b:  x(t) = a + b*time(t)
C

      b = sxt/stt
      a = Meanx - (b*Meant)

C
C     Store OLS residuals in x
C
      Do 3,t=1,n
	 x(t) = x(t) - (a + (b*t))
3     Continue

      Return
      End



       Subroutine ESTARMA(w,a,nobs,npar,npma,par,pma)
       integer i,iadist,lagar(12),lagma(12),npar,npma,nobs
       real a(nobs),avar,const,par(12),pma(12),w(nobs),cov(24,24)
       external nspe,nslse


c
c      Standardize series. Upon return series has mean=0 & var=1.
c
       call standx(w,nobs)


c
c      Compute preliminary estimates with call to nspe
c
       wmean = 0.0
       iprint = 0
       relerr = 0.011
       maxit = 1000
       imean=0
       maxbc=0
       np=npar+npma+imean
       ldcov=np

       Do 1,i=1,npar
	  lagar(i) = i
1      Continue

       Do 2,i=1,npma
	  lagma(i) = i
2      Continue

       iadist = 0
       const = 0.0


       call nspe(nobs,w,iprint,imean,wmean,npar,npma,relerr,
     &           maxit,const,par,pma,avar)



c
c      Compute least squares estimates with call to nslse
c
       tolbc = 0.0
       tolss = 0.99
       iprint = 0
       

       call nslse(nobs,w,iprint,imean,wmean,npar,par,lagar,
     &            npma,pma,lagma,maxbc,tolbc,tolss,const,cov,
     &            ldcov,na,a,avar)
       return
       end

      SUBROUTINE STANDX(X,N)
      INTEGER N
      REAL X(N),S,MEAN,VAR,SD
C
C     STANDARDIZE VARIABLE X
C
C
C     FIRST CALCULATE MEAN
C
      S = 0.0
      DO 10, L=1,N
	 S = S+X(L)
10    CONTINUE
      MEAN = S / REAL(N)
C
C     NEXT CALCULATE VARIANCE
C
      S = 0.0
      DO 11, L=1,N
	 S = S + ((X(L)-MEAN)**2)
11    CONTINUE
      VAR = S / (N-1)
      SD = VAR**(.5)
C
C     STANDARDIZE BY SUBTRACTING OUT THE MEAN AND DIVIDING
C     THROUGH BY THE STANDARD DEVIATION
C
      DO 12, L=1,N
	 X(L) = (X(L) - MEAN) / SD
12    CONTINUE

      RETURN
      END


      Subroutine GENARMA(w,nw,npar,npma,par,pma,iseed,a)
       integer i,iadist,iseed,lagar(12),lagma(12)
       real a(nw+npma),avar,const,par(12),pma(12),w(nw),
     &      wi(1)

       external rnarm,rnset,rnget



       If (npar .gt. 0) Then
	  Do 1,i=1,npar
	     lagar(i) = i
1         Continue
       Endif
       If (npar .eq. 0) Then
	  lagar(1) = 1
       Endif

       If (npma .gt. 0) Then
	  Do 2,i=1,npma
	     lagma(i) = i
2         Continue
       Endif
       If (npma .eq. 0) Then
	   lagma(1) = 1
       Endif
       
       iadist = 0
       const = 0.0
       avar = 1.0
       call rnset(iseed)
       call rnarm(nw,const,npar,par,lagar,npma,pma,lagma,
     &            iadist,avar,a,wi,w)
       call rnget(iseed)
c
c      Standardize series. Upon return series has mean=0 & var=1.
c
       call standx(w,nw)

       Return
       End


      SUBROUTINE CALCTR(KMAX,N,X,TR,SDTR,VARTR)
      REAL M3,M4
      REAL S1,S2,S3,S4,TR(KMAX),X(N)
      REAL VARTR(KMAX),SDTR(KMAX)

c
c      Standardize series. Upon return series has mean=0 & var=1.
c
       call standx(x,n)


C
C     CALCULATE 3RD AND 4TH MOMENTS FOR
C     CALCULATION OF S.D. OF TR
C
      S3 = 0.0
      S4 = 0.0
      DO 13, L=1,N
	 S3 = S3 + (X(L)**3)
	 S4 = S4 + (X(L)**4)
13    CONTINUE
      M3 = S3 / N
      M4 = S4 / N
C
C     NEXT CALCULATE THE TR VALUES  AND STANDARD 
C     DEVIATIONS IN TWO LOOPS
C
      DO 14, L1=1,KMAX
      S1 = 0.0
      S2 = 0.0
	 DO 15, L2=(L1+1),N
	   S1 = S1 +  (X(L2)**2)*(X(L2-L1)**1)
	   S2 = S2 +  (X(L2)**1)*(X(L2-L1)**2)
15       CONTINUE
	 TR(L1) = (S1 - S2) / (N-L1)
	 Z1A = 2*(M4-(M3**2))
	 Z1 = Z1A / (N-L1)
	 Z2A = 2*(N-(2*L1))
	 Z2 = Z2A / ((N-L1)**2)
	 VARTR(L1) = (Z1-Z2) 
	 SDTR(L1) = VARTR(L1)**(.5)
14    CONTINUE
      RETURN
      END
